<?php
/**
 * The template for displaying all archives
 *
 * This is the template that displays all archives by default.
 * Please note that this is the WordPress construct of archives
 * and that other 'archives' on your WordPress site may use a
 * different template.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Brisbane-Building-Inspections
 */

get_header();
$post_type = get_queried_object();
$tax = $wp_query->get_queried_object();
$term = get_queried_object();
?>

<div class="py-lg-5">
    <div class="container pt-5">
        <div class="row justify-content-center">
            <?php if ( get_field('page_title', 'cpt_'.$post_type->rewrite['slug'].'') ) : ?>
                <div class="col-12 text-center">
                    <h1><?php echo get_field('page_title', 'cpt_'.$post_type->rewrite['slug'].''); ?></h1>
                </div>
            <?php endif; ?>
            <div class="col-1">
                <hr class="black">
            </div>
        </div>
    </div>
    
    <?php 
    if ( have_posts() ) { ?>

        <?php if(!isMobileDevice()): ?>
    	<div class="container py-5">
    	    <div class="row">
        	    <?php while ( have_posts() ) {
            		the_post(); ?>
            		<div class="col-12 col-lg pb-5 pb-lg-0 service-archive">
                        <a href="<?php the_permalink(); ?>" class="">
                            <div class="row">
                                <div class="col-12 pb-3">
                                    <?php 
                                    $image = get_field('service_icon_black');
                                    if( !empty( $image ) ): ?>
                                        <img src="<?php echo esc_url($image['url']); ?>" alt="<?php echo esc_attr($image['alt']); ?>" />
                                    <?php endif; ?>
                                </div>
                            </div>
                            <div class="row align-items-end pb-4">
                                <div class="col-8 pr-0">
                                    <h4 class="mb-0 d-flex align-items-end"><?php the_title(); ?></h4>
                                </div>
                                <div class="col-4 red-arrow">
                                    <img width="80" src="<?php echo get_stylesheet_directory_uri(); ?>/images/red-arrow.png" alt="red arrow">
                                </div>
                            </div>
                        </a>
                        <div class="indent-text-black">
                            <?php the_excerpt(); ?>
                        </div>
                    </div>
            	<?php } ?>
        	</div>
        </div>
        
        <?php else: ?>
        <div class="accordion service-archive" id="accordionExample">
            <?php while ( have_posts() ) {
            the_post(); ?>
            <div class="card">
                <div class="card-header pb-0" id="headingOne" data-toggle="collapse" data-target="#acc-<?php global $post; echo $post->post_name; ?>" aria-expanded="false" aria-controls="acc-<?php global $post; echo $post->post_name; ?>">
                    <div class="row">
                        <div class="col-12">
                            <?php 
                            $image = get_field('service_icon_black');
                            if( !empty( $image ) ): ?>
                                <img src="<?php echo esc_url($image['url']); ?>" alt="<?php echo esc_attr($image['alt']); ?>" />
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="row align-items-end pb-4">
                        <div class="col-8 pr-0">
                            <h4 class="mb-0 d-flex align-items-end"><?php the_title(); ?></h4>
                        </div>
                        <div class="col-4">
                            <img width="80" src="<?php echo get_stylesheet_directory_uri(); ?>/images/red-arrow.png" alt="red arrow">
                        </div>
                    </div>
                </div>

                <div id="acc-<?php global $post; echo $post->post_name; ?>" class="collapse" aria-labelledby="headingOne" data-parent="#accordionExample">
                    <div class="card-body">
                        <div class="indent-text-black">
                            <?php the_excerpt(); ?>
                        </div>
                        <a href="<?php the_permalink(); ?>" class="btn-link link-black">Find out More</a>
                    </div>
                </div>
            </div>
            <?php } ?>
        </div>
        <?php endif; ?>
    <?php } ?>
    
    <div class="container pb-5">
        <div class="row justify-content-center">
            <div class="col-1">
                <hr class="black">
            </div>
        </div>
</div>
</div>


<?php
get_footer();
