<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Brisbane-Building-Inspections
 */

?>
<!doctype html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="https://gmpg.org/xfn/11">
	
	<!-- Google Tag Manager -->
<script>(function(w,d,s,l,i){w[l]=w[l]||[];w[l].push({'gtm.start':
new Date().getTime(),event:'gtm.js'});var f=d.getElementsByTagName(s)[0],
j=d.createElement(s),dl=l!='dataLayer'?'&l='+l:'';j.async=true;j.src=
'https://www.googletagmanager.com/gtm.js?id='+i+dl;f.parentNode.insertBefore(j,f);
})(window,document,'script','dataLayer','GTM-P4LTNMT');</script>
<!-- End Google Tag Manager -->

	<link href="https://fonts.googleapis.com/css2?family=Merriweather:ital,wght@0,300;0,400;0,700;0,900;1,300;1,400;1,700;1,900&family=Palanquin:wght@400;500;600;700&family=Roboto:wght@700;900&display=swap" rel="stylesheet">

	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
	<!-- Google Tag Manager (noscript) -->
<noscript><iframe src="https://www.googletagmanager.com/ns.html?id=GTM-P4LTNMT"
height="0" width="0" style="display:none;visibility:hidden"></iframe></noscript>
<!-- End Google Tag Manager (noscript) -->
<div id="page" class="site">

	<div class="container-fluid header-container bg_op-black p-0">
		<div class="container main-header">
			<div class="row">
				<div class="col-12 header-top d-flex justify-content-between align-items-center py-lg-2 p-0">
					<div class="px-3">
						<?php the_custom_logo(); ?>
					</div>

					<div class="d-block d-lg-none">
						<?php wp_nav_menu( array( 'theme_location' => 'menu-1', 'menu_id' => 'primary-menu', ) ); ?>
					</div>
	
					<div class="header-contact-items d-none d-lg-flex align-items-center">
						<?php if ( get_field('opening_hours', 'option') ) : ?>
							<div class="contact-hours text-center d-inline-block">
								<p class="mb-0"><?php echo get_field('opening_hours', 'option'); ?></p>
							</div>
						<?php endif; ?>
	
						<div class="contact-phone d-inline-block border-l">
							<?php 
							$phone = get_field('phone', 'option');
							if( $phone ): 
								$phone_url = $phone['url'];
								$phone_title = $phone['title'];
								$phone_target = $phone['target'] ? $phone['target'] : '_self';
								?>
								<a class="text-center" href="<?php echo esc_url( $phone_url ); ?>" target="<?php echo esc_attr( $phone_target ); ?>"><?php echo esc_html( $phone_title ); ?></a>
							<?php endif; ?>
						</div>
					</div>
					
				</div>

				<div class="col-12 header-bottom d-none d-lg-flex justify-content-between align-items-center">
					<?php wp_nav_menu( array( 'theme_location' => 'menu-1', 'menu_id' => 'primary-menu', ) ); ?>
					<?php 
					$link = get_field('contact_page', 'option');
					if( $link ): 
						$link_url = $link['url'];
						$link_title = $link['title'];
						$link_target = $link['target'] ? $link['target'] : '_self';
						?>
						<a class="btn btn-red" href="<?php echo esc_url( $link_url ); ?>" target="<?php echo esc_attr( $link_target ); ?>"><?php echo esc_html( $link_title ); ?></a>
					<?php endif; ?>
				</div>
			</div>
		</div>
	</div>

	<?php
		$post_type = get_queried_object();
		$tax = $wp_query->get_queried_object();
		$term = get_queried_object();
		if(!is_front_page() ):
	?>
	<?php if(!get_field('dont_show_page_banner')): ?>

	<?php if ( get_field('banner_image', 'cpt_'.$post_type->rewrite['slug'].'') and is_archive() ) : ?>
	<div class="container-fluid background page-banner relative bg_black" style="background-image:url('<?php the_field('banner_image', 'cpt_'.$post_type->rewrite['slug'].''); ?>');">
	<?php elseif ( get_field('banner_image') ) : ?>
	<div class="container-fluid background page-banner relative bg_black" style="background-image:url('<?php the_field('banner_image'); ?>');">
	<?php else: ?>
	<div class="container-fluid background page-banner relative bg_black">
	<?php endif; ?>
		<div class="row">
			<div class="col-12">
				<div class="minus-header"></div>
			</div>
			<div class="container">
				<div class="row justify-content-center banner-height">
					<div class="col-12 pt-4">
						<div class="breadcrumbs">
							<?php if ( function_exists('yoast_breadcrumb') ) { yoast_breadcrumb('<p id="breadcrumbs">','</p>'); } ?>
						</div>
					</div>

					<div class="col-12 col-lg-9 text-center pt-5 pb-3 col-xl-7">
						<?php if (is_archive() and get_field('alternative_title', 'cpt_'.$post_type->rewrite['slug'].'')): ?>
							<h2 class="color_white"><?php echo get_field('alternative_title', 'cpt_'.$post_type->rewrite['slug'].''); ?></h2>
						<?php elseif (is_archive() and !get_field('alternative_title', 'cpt_'.$post_type->rewrite['slug'].'')): ?>
							<h2 class="color_white"><?php echo post_type_archive_title( '', false ); ?></h2>
						<?php elseif ( get_field('alternative_title') ) : ?>
							<h2 class="color_white"><?php echo get_field('alternative_title'); ?></h2>
						<?php else: ?>
							<h2 class="color_white"><?php the_title(); ?></h2>
						<?php endif; ?>
					</div>

					<?php if (is_archive() and get_field('banner_text', 'cpt_'.$post_type->rewrite['slug'].'')): ?>
						<div class="col-12 col-lg-7 pb-3 col-xl-7">
							<div class="intro text-center"><?php the_field('banner_text', 'cpt_'.$post_type->rewrite['slug'].''); ?></div>
						</div>
					<?php elseif ( get_field('banner_text') ) : ?>
						<div class="col-12 col-lg-7 pb-3 col-xl-7">
							<div class="intro text-center"><?php the_field('banner_text'); ?></div>
						</div>
					<?php endif; ?>

					<?php if (is_archive() and get_field('banner_list', 'cpt_'.$post_type->rewrite['slug'].'')): ?>
						<div class="col-10 col-lg-6 banner-list px-lg-5">
							<?php the_field('banner_list', 'cpt_'.$post_type->rewrite['slug'].''); ?>
						</div>
					<?php elseif ( get_field('banner_list') ) : ?>
						<div class="col-10 col-lg-6 banner-list px-lg-5">
							<?php the_field('banner_list'); ?>
						</div>
					<?php endif; ?>

					<div class="col-12 pb-5"></div>
				</div>
			</div>
		</div>
	</div>
	<?php else: ?>
	<?php if ( get_field('background_image_no_text') ) : ?>
	<div class="container-fluid background relative bg_black" style="background-image:url('<?php the_field('background_image_no_text'); ?>'); min-height:<?php the_field('min_height'); ?>px">
	<?php else: ?>
	<div class="container-fluid background relative bg_black">
	<?php endif; ?>
		<div class="row">
			<div class="col-12">
				<div class="minus-header"></div>
			</div>
			<div class="container">
				<div class="row justify-content-center">
					<div class="col-12 pt-3 pb-4">
						<div class="breadcrumbs">
							<?php if ( function_exists('yoast_breadcrumb') ) { yoast_breadcrumb('<p id="breadcrumbs">','</p>'); } ?>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
	<?php if ( get_field('title_no_banner') ) : ?>
	<div class="container py-5">
		<div class="row">
			<div class="col-12">
				<h1><?php the_field('title_no_banner'); ?></h1>
			</div>
		</div>
	</div>
	<?php endif; ?>

	<?php endif; ?>

	<?php endif; ?>

	
	<?php if( get_field('background_texture') ): ?>
	<div id="content" class="site-content bg_texture">
	<?php else: ?>
	<div id="content" class="site-content">
	<?php endif; ?>


	