<?php
/**
 * The template for displaying all pages
 *
 * This is the template that displays all pages by default.
 * Please note that this is the WordPress construct of pages
 * and that other 'pages' on your WordPress site may use a
 * different template.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Brisbane-Building-Inspections
 */

get_header();
?>


<div class="page-title bg_texture">
    <?php
    if( have_rows('slide') ): ?>
        <div class="owl-carousel home">
            <?php while ( have_rows('slide') ) : the_row(); ?>					
                <div class="item">
                    <div class="home-bg background d-flex justify-content-center align-items-center" style="background-image:url('<?php the_sub_field('background_image'); ?>');">
                        <div class="container">
                            <div class="row justify-content-center">
                                <div class="col-12">
                                    <div class="minus-header"></div>
                                </div>
                                <div class="d-block d-lg-none mobile-home-banner-img">
                                    <img src="<?php the_sub_field('background_image'); ?>" alt="banner image">
                                </div>
                                <div class="col-12 col-md-11 col-lg-10 col-xl-8 py-5 slider-text-home">
                                    <div class="py-lg-5">
                                        <h1><?php the_sub_field('title'); ?></h1>
                                        <div class="px-lg-5 py-4">
                                            <?php the_sub_field('text'); ?>
                                        </div>
                                        <div class="home-buttons text-center pt-4 pt-lg-0">
                                            <?php 
                                            $link = get_sub_field('red_button');
                                            if( $link ): 
                                                $link_url = $link['url'];
                                                $link_title = $link['title'];
                                                $link_target = $link['target'] ? $link['target'] : '_self';
                                                ?>
                                                <div class="d-inline-block px-2"><a class="btn btn-red" href="<?php echo esc_url( $link_url ); ?>" target="<?php echo esc_attr( $link_target ); ?>"><?php echo esc_html( $link_title ); ?></a></div>
                                            <?php endif; ?>
                                            <?php 
                                            $link = get_sub_field('white_button');
                                            if( $link ): 
                                                $link_url = $link['url'];
                                                $link_title = $link['title'];
                                                $link_target = $link['target'] ? $link['target'] : '_self';
                                                ?>
                                                <div class="d-inline-block px-2"><a class="btn-link link-white" href="<?php echo esc_url( $link_url ); ?>" target="<?php echo esc_attr( $link_target ); ?>"><?php echo esc_html( $link_title ); ?></a></div>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endwhile; ?>
        </div>
    <?php endif; ?>
</div>

<div class="bg_texture">
    <div class="bg_op-black">
        <div class="container py-5">
            <div class="row align-items-end">
                    <?php
                    $loop = new WP_Query( array( 'post_type' => 'services', 'posts_per_page' => 5 ) );
                    if ( $loop->have_posts() ) :
                        while ( $loop->have_posts() ) : $loop->the_post(); ?>
                            <div class="col-12 col-lg service-icons pb-5 pb-lg-0">
                                <a href="<?php the_permalink(); ?>">
                                    <div class="row align-items-center">
                                        <div class="col-3"><img width="47" class="service-icon" src="<?php the_post_thumbnail_url(); ?>" alt="service icon"></div>
                                        <div class="col-6 p-0"><h4 class="mb-0"><?php the_title(); ?></h4></div>
                                        <div class="col-3 align-self-end pr-1 pl-1 red-arrow-service"><img width="80" src="<?php echo get_stylesheet_directory_uri(); ?>/images/red-arrow.png" alt="red arrow"></div>
                                    </div>
                                </a>
                            </div>
                        <?php endwhile;
                    endif;
                    wp_reset_postdata();
                    ?>
            </div>
        </div>
    </div>
</div>

<?php include 'custom-rows.php' ?>
    

<?php
get_footer();
